/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.CustomListCell;
import cds.aladin.Server;
import cds.aladin.ServerTap;
import cds.aladin.TapTableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CustomListCellRenderer
extends JLabel
implements ListCellRenderer {
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private Map<String, CustomListCell> model;
    public ServerTap serverTap;

    public CustomListCellRenderer() {
    }

    public CustomListCellRenderer(ServerTap serverTap) {
        this.serverTap = serverTap;
    }

    public CustomListCellRenderer(Map<String, CustomListCell> model) {
        this.model = model;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel column = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String textToSet = null;
        String tooltip = null;
        if (value instanceof TapTableColumn) {
            String alias;
            TapTableColumn tapTableColumn = (TapTableColumn)value;
            textToSet = tapTableColumn.getColumn_name();
            if (this.serverTap != null && (alias = this.serverTap.getRelevantAlias(tapTableColumn)) != null) {
                textToSet = alias + "." + textToSet;
            }
            tooltip = tapTableColumn.getDescription();
        } else if (this.model != null && this.model.get(value) != null) {
            tooltip = this.model.get((Object)value).tooltip;
        }
        StringBuffer texter = new StringBuffer("<html><p>").append(textToSet).append("</p></html>");
        int width = column.getWidth();
        if (width <= 0) {
            width = 150;
        }
        column.setPreferredSize(new Dimension(width, Server.HAUT));
        if (textToSet != null) {
            column.setText(texter.toString());
        }
        if (tooltip == null || tooltip.isEmpty()) {
            column.setToolTipText(null);
        } else {
            tooltip = new StringBuffer("<html><p width=\"500\">").append(tooltip).append("</p></html>").toString();
            column.setToolTipText(tooltip);
        }
        return column;
    }
}

